# A3 Monotone Ladder Audit (Zero‑Touch)

This bundle reproduces the **A3: Monotone Ladder Audit** used to sanity‑check a rotation‑invariant, inward‑monotone schedule for the +1 ParentGate layer in the absolute altitude framework.

## What it checks
1. **Declaration**: `strictness_by_shell` is monotone inward (index 0 = innermost).  
2. **Observed behavior**: a deterministic availability model yields acceptance rates that are **lowest inward and non‑decreasing outward**; no easing toward the center.  
3. **PASS** requires: schedule `ON` ∧ declaration monotone ∧ 0 observed violations.

## How to run (no deps; stdlib only)
```bash
python engine_a3_monotone.py \
  --manifest config/manifest.json \
  --diag config/diagnostics.json \
  --out outputs
```
Windows:
```bat
python engine_a3_monotone.py --manifest config\manifest.json --diag config\diagnostics.json --out outputs
```

Artifacts will appear in `outputs/`:
- `metrics/acceptance_by_shell.csv`
- `audits/monotone_schedule.json`
- `run_info/hashes.json`

## Current config
- shells strictness: [3,2,2,1]
- ticks: 128
- attempts per shell per tick: 2000
- tau_mono: 0.0
- created_at_utc: 2025-11-05T14:22:33Z

